IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_RC_DEB_HISTORICO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_RC_DEB_HISTORICO]
GO

CREATE PROCEDURE [dbo].[P_RC_DEB_HISTORICO] @DT_PROC DATETIME=NULL WITH ENCRYPTION AS 
	SET NOCOUNT ON	

	DECLARE @DT_FIM DATETIME, @DIA DATETIME
	DECLARE @CD_FILIAL AS INT
	DECLARE @CD_EMP INT

    DECLARE CfiliaisReceberProc CURSOR FAST_FORWARD FOR 
	SELECT  
		CD_EMP, 
		CD_FILIAL, 
		DT_PROC
	FROM
		(		  
		SELECT  CD_EMP, CD_FILIAL, DT_PROC FROM  RC_DEB_POSICAO_FINANCEIRA_PROCESSAR
		UNION ALL SELECT  CD_EMP, CD_FILIAL, DT_PROC FROM  RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_CHQ_DEPOS_CPL
		UNION ALL SELECT  CD_EMP, CD_FILIAL, DT_PROC FROM  RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_CHQ_DEVO
		UNION ALL SELECT  CD_EMP, CD_FILIAL, DT_PROC FROM  RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_CHQ_LANC_CPL
		UNION ALL SELECT  CD_EMP, CD_FILIAL, DT_PROC FROM  RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_CHQ_REPA_CPL
		UNION ALL SELECT  CD_EMP, CD_FILIAL, DT_PROC FROM  RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_PDV_VD_CANCEL_CONV
		UNION ALL SELECT  CD_EMP, CD_FILIAL, DT_PROC FROM  RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_PDV_VD_CANCEL_TEF
		UNION ALL SELECT  CD_EMP, CD_FILIAL, DT_PROC FROM  RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_PG_CRED
		UNION ALL SELECT  CD_EMP, CD_FILIAL, DT_PROC FROM  RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_PG_DEB
		UNION ALL SELECT  CD_EMP, CD_FILIAL, DT_PROC FROM  RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_RC_CRED
		UNION ALL SELECT  CD_EMP, CD_FILIAL, DT_PROC FROM  RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_RC_CREDIARIO_FECHA
		UNION ALL SELECT  CD_EMP, CD_FILIAL, DT_PROC FROM  RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_RC_PGTO_PDV
		UNION ALL SELECT  CD_EMP, CD_FILIAL, DT_PROC FROM  RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_RC_VD_CONV
		UNION ALL SELECT  CD_EMP, CD_FILIAL, DT_PROC FROM  RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_RC_CREDIARIO_PARC) A
	ORDER BY
		CD_EMP, 
		CD_FILIAL,
		DT_PROC
	
	OPEN CfiliaisReceberProc


	FETCH NEXT FROM CfiliaisReceberProc INTO @CD_EMP,@CD_FILIAL,@DT_PROC
		WHILE @@FETCH_STATUS=0
		  BEGIN
				
				PRINT '***************'
				PRINT '  Filial ' + CONVERT(VARCHAR, @CD_FILIAL)
				PRINT '***************'

						PRINT 'P_SALVAR_DEMANDA - DELETE 1 '+CONVERT(VARCHAR, GETDATE(), 108); 
						PRINT 'Filial: ' + CONVERT(VARCHAR,@CD_FILIAL);
						PRINT 'Dia: ' + CONVERT(VARCHAR, @DIA, 112);
					
					IF @CD_FILIAL >0 
						BEGIN
							PRINT 'EXEC 2 '+CONVERT(VARCHAR, GETDATE(), 108);
							EXEC P_RC_DEB_HISTORICO_FILIAL @CD_EMP,@CD_FILIAL,@DIA
						END
					ELSE
						BEGIN
							PRINT 'EXEC 3 '+CONVERT(VARCHAR, GETDATE(), 108);
							EXEC P_RC_DEB_HISTORICO_CHQ_LANC_CPL @CD_EMP,@DIA
							
							PRINT 'EXEC 4 '+CONVERT(VARCHAR, GETDATE(), 108);
							EXEC P_RC_DEB_HISTORICO_RC_CREDIARIO_PARC @CD_EMP,@DIA
							
							PRINT 'EXEC 5 '+CONVERT(VARCHAR, GETDATE(), 108);
							EXEC P_RC_DEB_HISTORICO_RC_VD_CONV @CD_EMP,@DIA
						END					
						
					--Marcando processo ja efetuado	
					PRINT 'DELETE 6 '+CONVERT(VARCHAR, GETDATE(), 108);
					DELETE FROM  RC_DEB_POSICAO_FINANCEIRA_PROCESSAR					WHERE CD_EMP=@CD_EMP AND CD_FILIAL =@CD_FILIAL AND DT_PROC = @DT_PROC;		
					DELETE FROM  RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_CHQ_DEPOS_CPL		WHERE CD_EMP=@CD_EMP AND CD_FILIAL =@CD_FILIAL AND DT_PROC = @DT_PROC;		
					DELETE FROM  RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_CHQ_DEVO			WHERE CD_EMP=@CD_EMP AND CD_FILIAL =@CD_FILIAL AND DT_PROC = @DT_PROC;
					DELETE FROM  RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_CHQ_LANC_CPL		WHERE CD_EMP=@CD_EMP AND CD_FILIAL =@CD_FILIAL AND DT_PROC = @DT_PROC;
					DELETE FROM  RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_CHQ_REPA_CPL		WHERE CD_EMP=@CD_EMP AND CD_FILIAL =@CD_FILIAL AND DT_PROC = @DT_PROC;
					DELETE FROM  RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_PDV_VD_CANCEL_CONV	WHERE CD_EMP=@CD_EMP AND CD_FILIAL =@CD_FILIAL AND DT_PROC = @DT_PROC;
					DELETE FROM  RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_PDV_VD_CANCEL_TEF	WHERE CD_EMP=@CD_EMP AND CD_FILIAL =@CD_FILIAL AND DT_PROC = @DT_PROC;
					DELETE FROM  RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_PG_CRED			WHERE CD_EMP=@CD_EMP AND CD_FILIAL =@CD_FILIAL AND DT_PROC = @DT_PROC;
					DELETE FROM  RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_PG_DEB				WHERE CD_EMP=@CD_EMP AND CD_FILIAL =@CD_FILIAL AND DT_PROC = @DT_PROC;
					DELETE FROM  RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_RC_CRED			WHERE CD_EMP=@CD_EMP AND CD_FILIAL =@CD_FILIAL AND DT_PROC = @DT_PROC;
					DELETE FROM  RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_RC_CREDIARIO_FECHA	WHERE CD_EMP=@CD_EMP AND CD_FILIAL =@CD_FILIAL AND DT_PROC = @DT_PROC;
					DELETE FROM  RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_RC_PGTO_PDV		WHERE CD_EMP=@CD_EMP AND CD_FILIAL =@CD_FILIAL AND DT_PROC = @DT_PROC;
					DELETE FROM  RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_RC_VD_CONV			WHERE CD_EMP=@CD_EMP AND CD_FILIAL =@CD_FILIAL AND DT_PROC = @DT_PROC;
					DELETE FROM  RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_RC_CREDIARIO_PARC	WHERE CD_EMP=@CD_EMP AND CD_FILIAL =@CD_FILIAL AND DT_PROC = @DT_PROC;
				
				FETCH NEXT FROM CfiliaisReceberProc INTO @CD_EMP,@CD_FILIAL,@DT_PROC
		  END
		 
CLOSE CfiliaisReceberProc;
DEALLOCATE CfiliaisReceberProc;

PRINT 'P_RC_DEB_HISTORICO FINALIZADA!'